%%
%ROF denoise for grayscale image by solving PDE with time
function u = ROF_denoise_PDE(img, tilde_lambda, tilde_dt, maxite)   %(tilde_lambda = h*lambda)   tilde_dt=dt/h


img = double(img);
v = img;

for n = 1 : maxite

%compute diff
[fdx,fdy] = forwarddiff(v);
[bdx,bdy] = backwarddiff(v);
F = getF(fdx,fdy,bdx,bdy);

%update
u = v+tilde_dt*tilde_lambda*(img-v)+tilde_dt*F;

%handle boundary 
%u(1,2:N-1,:)=u(2,2:N-1,:);
%u(M,2:N-1,:)=u(M-1,2:N-1,:);
%u(:,1,:)=u(:,2,:);
%u(:,N,:)=u(:,N-1,:);

%change
v=u;

if mod(n,1000) == 0
    fprintf('%g iterations \n',n);
end

end

end

%%
function out = m(a, b)

out = (sign(a)+sign(b)).*min(abs(a),abs(b))/2;

end

%%
function F = getF(fdx,fdy,bdx,bdy)

[bddx,~] = backwarddiff(fdx./sqrt(fdx.^2+m(fdy,bdy).^2+1e-8));
[~,bddy] = backwarddiff(fdy./sqrt(fdy.^2+m(fdx,bdx).^2+1e-8));
F = bddx+bddy;

end

%%
function [dx,dy] = forwarddiff(img)    

[M,N,~] = size(img);
dx = img(:,[2:N,N],:)-img;
dy = img([1,1:M-1],:,:)-img;

end
%%
function [dx,dy] = backwarddiff(img)    

[M,N,~] = size(img);
dx = img-img(:,[1,1:N-1],:);
dy = img-img([2:M,M],:,:); 

end