function [u] = ROF_denoise_split_bregman(f,tilde_lambda,tilde_gamma) %tilde_lambda = h*lambda  tilde_gamma = gamma/h

%initial set
tol = sqrt(sum(sum(f.^2)))/1000;
err = 1e4;
u = f;
d = zeros(size(f,1),size(f,2),2);
b = d;

%iterative
while err > tol
    newu = update_u(f,u,d,b,tilde_lambda,tilde_gamma);
    
    gradu = grad(newu);%used in update d b, compute only once
    
    newd = update_d(gradu,b,tilde_gamma);
    
    newb = update_b(gradu,b,newd);
    
    %calculate err
    err = sqrt(sum(sum((newu-u).^2)));
   
    
    %update
    u = newu;
    
    d = newd;
    
    b = newb;
    
end

end

%function for update u
function newu = update_u(f,u,d,b,tilde_lambda,tilde_gamma)
[M,N]=size(f);
u=[u(:,1),u,u(:,N)];
u=[u(1,:);u;u(M,:)];
divdb = div(d-b);

for i=M+1:-1:2      
    for j=2:N+1
        u(i,j)=(tilde_lambda*f(i-1,j-1)-tilde_gamma*divdb(i-1,j-1)+tilde_gamma*(u(i-1,j)+u(i+1,j)+u(i,j-1)+u(i,j+1)))/(tilde_lambda+4*tilde_gamma);
    end
end

newu=u(2:M+1,2:N+1);

end

%function for update d
function newd = update_d(gradu,b,tilde_gamma)
ub = gradu+b;
lub = sqrt(ub(:,:,1).^2+ub(:,:,2).^2);
newd = (ub./(lub+1e-8)).*max(lub-1/tilde_gamma,0);

end

%function for update b
function newb = update_b(gradu,b,newd)
newb    = b+gradu-newd;

end

%calculate gradient u  
function gradu = grad(u)    
gradu = zeros(size(u,1),size(u,2),2);
[M,N,~] = size(u); 

dx = u(:,[2:N,N],:)-u;     %(forward difference)
dy = u([1,1:M-1],:,:)-u;

%dx = (u(:,[2:N,N],:)-u(:,[1,1:N-1],:))/2;  %(central difference)
%dy = (u([1,1:M-1],:,:)-u([2:M,M],:,:))/2;

gradu(:,:,1) = dx;
gradu(:,:,2) = dy;

end

%calculate divergence of d-b
function divdb = div(db)
[M,N,~] = size(db);

dx = db(:,:,1)-db(:,[1,1:N-1],1);  %(backward difference)
dy = db(:,:,2)-db([2:M,M],:,2); 
divdb = dx+dy;

%dx = (db(:,[2:N,N],1)-db(:,[1,1:N-1],1))/2;  %(central difference)
%dy = (db([1,1:M-1],:,2)-db([2:M,M],:,2))/2;
%divdb = dx+dy;

end