model = createpde(2);
geometryFromEdges(model,@Pacman_domain);

initfun = @(location) [5*(location.y < 0);3*(location.y > 0)];
setInitialConditions(model,initfun);

applyBoundaryCondition(model,'neumann','Edge',1:model.Geometry.NumEdges,'g',[0;0]);

ccoeffunction = @(location,state) [2-tanh(state.u(2,:)); 2+tanh(state.u(1,:))];
acoeffunction = @(location,state) [0.16-0.08*state.u(2,:); 0.9*state.u(1,:)-4.5];
specifyCoefficients(model,'m',0,...
                                    'd',1,...
                                    'c',ccoeffunction,...
                                    'a',acoeffunction,...
                                    'f',[0;0]);
generateMesh(model,'Hmax',0.1);
dt = 0.01;
tlist = 0:dt:20;
results = solvepde(model,tlist);

figure(1)
for j=1:length(tlist)
    subplot(1,2,1)
    pdeplot(model,'XYData',results.NodalSolution(:,1,j));
    axis equal;
    title(['The population of foxes at time t = ',num2str((j-1)*dt)])
    subplot(1,2,2)
    pdeplot(model,'XYData',results.NodalSolution(:,2,j));
    axis equal
    title(['The population of rabbits at time t = ',num2str((j-1)*dt)])
    drawnow;
end