function [x,y] = Pacman_domain(bs,s)

switch nargin
    case 0
        x = 3; % total number of curves (most of them are boundary curves, but sometimes the interface between regions)
    return
      
    case 1
        dl = [-3*pi/4   0   0    % start parameter values of each interval which corresponds to one particular curve
               3*pi/4   1   1    % end parameter values of each interval which corresponds to one particular curve
               1        0   1    % The region label on the LHS when travelling along each curve as the parameter increases
               0        1   0];  % The region label on the RHS when travelling along each curve as the parameter increases
        x = dl(:,bs);
        return
        
    case 2
        x = zeros(size(s));
        y = zeros(size(s));
        if numel(bs) == 1 % Does bs need scalar expansion?
            bs = bs*ones(size(s)); % Expand bs
        end
        cbs = find(bs == 1);
        x(cbs) = cos(s(cbs));
        y(cbs) = sin(s(cbs));

        cbs = find(bs == 2);
        x(cbs) = cos(3*pi/4)*s(cbs);
        y(cbs) = sin(3*pi/4)*s(cbs);
        
        cbs = find(bs == 3);
        x(cbs) = cos(3*pi/4)*s(cbs);
        y(cbs) = -sin(3*pi/4)*s(cbs);
     return
end