function [ sol_u ] = Poisson1Dsolver( force, bdry_data, mesh_number)
%This Matlab code is to solve 1D Poisson equations with Dirichlet boundary
%condition in [0,1]
% -\triangle u =f on [0,1]
% date: 10/12/2013
% version: 2


% mesh generation

mesh_size=1/mesh_number;
x=0:mesh_size:1;

% boundary condition
sol_u(1:mesh_number)=0;
sol_u(1)=bdry_data(0);
sol_u(mesh_number+1)=bdry_data(1);

% Matrix Formulation
A=spdiags(ones(mesh_number-1,1)*[1 -2 1],-1:1,mesh_number-1, mesh_number-1);

% right-hand-side

b=-mesh_size^2*force(mesh_size:mesh_size:1-mesh_size);
b(1)=b(1)-sol_u(1);
b(mesh_number-1)=b(mesh_number-1)-sol_u(mesh_number+1);

% solve sol_u
sol_u(2:mesh_number)=A\b';

%graph
plot(x,sol_u)
title('numerical solution to 1D Poisson equation')

figure;
plot(x,abs(sol_u-sin(x)))



end

